//Exp-10 Speech coding using Long Term Predictive coder
//This code read wav file and play original signal and compressed signal
// It also plots original signal as well as compressed signal

function [aCoeff, tcount_of_aCoeff, e] = func_lev_durb(y, M);
//M=order and y is array of the data point  of the current frame
sk=0;       //initializing summartion term "sk"
a=[zeros(M+1);zeros(M+1)]; //defining a matrix of zeros for "a" for init.
//MAIN BODY OF THIS PROGRAM STARTS FROM HERE>>>>>>>>>>>>>>
z=xcorr(y);

//finding array of R[l]
R=z( ( (length(z)+1) ./2 ) : length(z)); //R=array of "R[l]", where l=0,1,...(b+N)-1  %R(1)=R[lag=0], R(2)=R[lag=1], %R(3)=R[lag=2]... etc 

//GETTING OTHER PARAMETERS OF PREDICTOR OF ORDER "0":
s=1;        //s=step no.
J(1)=R(1);          //J=array of "Jl", where l=0,1,2...(b+N)-1,   J(1)=J0, J(2)=J1, J(3)=J2 etc

//GETTING OTHER PARAMETERS OF PREDICTOR OF ORDER "(s-1)"
for s=2:M+1,
    sk=0;               //clearing "sk" for each iteration
    for i=2:(s-1),
        sk=sk + a(i,(s-1)).*R(s-i+1);
    end                 //now we know value of "sk", the summation term
                        //of formula of calculating "k(l)"
    k(s)=(R(s) + sk)./J(s-1);
    J(s)=J(s-1).*(1-(k(s)).^2);
    
    a(s,s)= -k(s);
    a(1,s)=1;
    for i=2:(s-1),
        a(i,s)=a(i,(s-1)) - k(s).*a((s-i+1),(s-1));
    end
    end
//increment "b" and do same for next frame until end of frame when 
//combining this code with other parts of LPC algo

//PREDICTION ERROR; FOR TESTING THE ABOVE PREDICTOR
aCoeff=a((1:s),s)';       //array of "a(i,s)", where, s=M+1
tcount_of_aCoeff = length(aCoeff);

 y_padded_for_delay_r = [y'; zeros(1,1)]; //it is padded with zeros to remove the effect of delay in filter
 est_y_with_dummy_pad = filter([0 -aCoeff(2:9)],1,y_padded_for_delay_r);    // = s^(n) with a cap on page 92 of the book
est_y = est_y_with_dummy_pad(2:321);    
e = y' - est_y;      //supposed to be a white noise
endfunction

function [aCoeff, b_LTopt, Topt, e_prime] = f_ENCODER_relp(x, fs)
M = 8; //prediction order for LP analysis
//INITIALIZATION;
b=1;        //index no. of starting data point of current frame
fsize = 20e-3;    //frame size (in milisec)   
frame_length = round(fs .* fsize);   //=number data points in each framesize of "x"
N= frame_length - 1; //N+1 = frame length = number of data points in each framesize

y_proc = filter([1 -1], [1 -0.999], x);  //pre-processing
//FRAME SEGMENTATION
for b=1 : frame_length : (length(x) - N)

y_f = y_proc(b:b+N);     //"b+N" denotes the end point of current frame. "y" denotes an array of the data points of the current frame
 //LP ANALYSIS [lev-durb] & PREDICTION ERROR (short-term) FILTER;
    [a, tcount_of_aCoeff, e_s] = func_lev_durb (y_f, M); //e=error signal from lev-durb proc
    aCoeff(b: (b + tcount_of_aCoeff - 1)) = a;  //aCoeff is array of "a" for whole "x"
    //LONG-TERM LP ANALYSIS, FILTERING, AND CODING analysis:
    T_min = round (fs .* 5e-3);  //=total data points in 5ms of "x"    
    T_max = round (fs .* 15e-3);   
    c1 = 1;
    for bs = b : 40 : b+length(y_f)-40  //subframing bs = 1281;
        if bs < T_max
            break;
        end
    
        Jmin(bs) = 10^9;
    
        for T = T_min : T_max      //within 1 (current) frame  T = 40;  
                for c = 1:40   //data points of current subframe c=1; temporary
                    sm1(c) = ( y_proc(bs+(c-1)) .* y_proc(bs-T+(c-1))); //es(n) 
                    sm2(c) = y_proc(bs-T+(c-1)); //=es(n-T)
                    sm22(c) = sm2(c).^2;
                end
                q1 = sum(sm1);
                q2 = sum(sm22);
                b_LT(T) = -(q1./q2);
            //J loop:
                for c = 1:40    //data points of current subframe c=1; temporary
                    smJ1(c) = y_proc(bs+(c-1));
                    smJ2(c) = b_LT(T) .* y_proc(bs-T+(c-1));            
                end            
                smJ = smJ1 + smJ2;
                qJ = smJ.^2;
                J(T) = sum(qJ);
            
                if J(T) < Jmin(bs),
                    Jmin(bs) = J(T);
                    Topt(bs) = T;
                    if b_LT(T)>=1,
                        b_LTopt(bs) = 0.9999; //trancation
                    else
                        b_LTopt(bs) = b_LT(T);
                    end
                else
               end
        end     //T loop ends
        //predictor:
        LT_gain = [zeros(1, Topt(bs)-1), b_LTopt(bs)];     //as it says z^-T in page 121
         e_s_padded_for_delay_r = [e_s(c1:c1+39); zeros(Topt(bs), 1)]; //it is padded with zeros to remove the effect of delay in filter. %Topt(bs) no. of 'z's and one '1' results in total 'Topt(bs)' amount of delay
        e_with_dummy_pad = filter([1 LT_gain], 1,  e_s_padded_for_delay_r);   // = 1 + 0*z^-1 + 0*z^-2 + ... + b*z^-T
         e_LT(bs:bs+39,1) = e_with_dummy_pad(Topt(bs)+1 : Topt(bs)+1+39);   //LT predicted "e"
        e(bs:bs+39, 1) = e_s(c1 : c1+39) - e_LT(bs : bs+39);
        
        //WEIGHTING FILTER:
        w = [-0.0004; -0.0156;-0.0677;0.0545;0.6069;1.0000;0.6069;0.0545;-0.0677;-0.0156;-0.0004];  //11 point flattop window is temporarily chosen
        wndd = conv(w, e(bs:bs+39));     //outputs total 50 samples
        x_n(bs:bs+39) = wndd(6:45);  //middle 40 samples are taken

        //POSITION SELECTION & EXCITATION GENERATOR:
        for i1 = 0:3  
            for i = i1+bs : 3 : bs+i1+38;
                x_m(i1+1,i) = x_n(i);
            end
            
            E_m(i1+1,1) = sum((x_m(i1+1, bs:3)).^2);
        end
        [E_m_max, index_max] = gsort(E_m);
        e_prime(bs : bs+39) = x_m(index_max(4), bs:bs+39); 
        c1 = c1 + 40;
    end
end
endfunction

//RELP DECODER portion:
function [synth_speech, synth_speech1, LT_gain, e_prime_pad_for_d_r, e_prime_op_dummy_pad,e_prime_op, e_prime_op_pad_delay_r,synth_speech_dummy_pad] = f_DECODER_relp(aCoeff, b_LTopt, Topt, e_prime)
//re-calculating frame_length for this decoder
frame_length=9; //initial value for calculation
for i=10:length(aCoeff)
    if aCoeff(i) == 0
        frame_length = frame_length + 1;
    else break;
    end
end     
e_prime = e_prime';     //making it a column matrix for convenience

for b=1 : frame_length : length(aCoeff)    //length(aCoeff) should be very close (i.e less than a frame_length error) to length(x)
    for bs = b : 40 : b+frame_length-40  //subframing
        
        //EXCITATION GENERATOR:  not done yet. because e_prime has been sent to this decoder directly. without quantization.
        //PITCH SYNTHESIS FILTER:    %has to be done per subframe
        LT_gain = [zeros(1, Topt(bs)-1), b_LTopt(bs)];     //as it says z^-T
         e_prime_pad_for_d_r = [e_prime(bs:bs+39); zeros(Topt(bs), 1)]; //it is padded with zeros to remove the effect of delay in filter. %Topt(bs) no. of 'z's and one '1' results in total 'Topt(bs)' amount of delay
        e_prime_op_dummy_pad = filter(1, [1 LT_gain],  e_prime_pad_for_d_r);  //= 1 / (1 + 0*z^-1 + 0*z^-2 + ... + b*z^-T)
        e_prime_op(bs:bs+39,1) = e_prime_op_dummy_pad(Topt(bs)+1 : Topt(bs)+1+39);   //pitch-synthesis filter output
    end        //FORMANT SYNTHESIS FILTER:
       e_prime_op_pad_delay_r= [e_prime_op(b : b+159); zeros(1,1)]; //it is padded with zeros to remove the effect of delay in filter
        synth_speech_dummy_pad = filter(1, [1 aCoeff(b+1 : b+8)], e_prime_op_pad_delay_r);    
        synth_speech1(b : b+159) = synth_speech_dummy_pad (2:161);   //DE-EMPHASIS (de-proprocessing):
        synth_speech(b : b+159) = filter([1 -0.999], [1 -1], synth_speech1(b : b+159));  //De-processing
end
endfunction

clc;
clear all;
xdel(winsid());
inpfilenm = "SCI/modules/sound/demos/s1ofwb.wav";
[x,fs,bits] =wavread(inpfilenm);

t=length(x)./fs;// total time t seconds
//COMPRESSION STARTS HERE,
disp('original signal');
sound(x, fs);
[aCoeff, b_LTopt, Topt, e_prime] = f_ENCODER_relp(x, fs);

        // e_prime is instead of position, peak_magitude_index and sample_amplitude_index. (temporarily)
//halt()
//halt('Press a key to play the original sound!')

[synth_speech] = f_DECODER_relp(aCoeff, b_LTopt, Topt, e_prime);

//RESULTS,


disp('compressed signal');
sound(synth_speech, fs);

figure;
subplot(211),
plot(x); title(['Original signal = "', inpfilenm, '"']);
subplot(212), plot(synth_speech); title('RELP compressed output');
//Output plays original signal and after approximately 5 minutes it plays compressed sound and plot the original signal and compressed signal.
